function plot_samples(D, core)

% This function plots the sample measurements and uncertainties within
% fitting_model_concs.m.

% check core being analysed
if core == 2
    %name = 'BH02';
    tic14 = [0 5000 10000 15000 20000 25000 30000]; % for BH02
else 
    %name = 'BH03';
    tic14 = [0 5000 10000 15000 20000 25000 30000]; % for BH03
end

thisd = D;% .(name);

% Define colours
d_col = [0.86,0.098,0.106]; % dark red
m_col = [0.92, 0.703, 0.68];
l_col = [0.98,0.703,0.68]; % light red
grayColor = [.7 .7 .7];
ticz = [0 0.1 0.2 0.3 0.4 0.5];

% axes(ax1l);
for a = 1:length(thisd.n14_concs)
    % do uncert
    N14_low95 = (thisd.n14_concs(a) - 2*thisd.dN14(a));
    N14_upp95 = (thisd.n14_concs(a) + 2*thisd.dN14(a));
    N14_low68 = (thisd.n14_concs(a) - thisd.dN14(a));
    N14_upp68 = (thisd.n14_concs(a) + thisd.dN14(a));
    xx95 = [N14_low95 N14_low95 N14_upp95 N14_upp95 N14_low95];
    yy95 = [thisd.top_z(a) thisd.btm_z(a) thisd.btm_z(a) thisd.top_z(a) thisd.top_z(a)];
    xx68 = [N14_low68 N14_low68 N14_upp68 N14_upp68 N14_low68];
    yy68 = [thisd.top_z(a) thisd.btm_z(a) thisd.btm_z(a) thisd.top_z(a) thisd.top_z(a)];
  
    plot(xx95, yy95, 'color', d_col)
    hold on
    fill(xx68, yy68, l_col)
    hold on
    
    % mean  
    xxmean = [thisd.n14_concs(a) thisd.n14_concs(a)];
    yymean = [thisd.btm_z(a) thisd.top_z(a)];
 
    plot(xxmean, yymean, 'Color','k')
end

% adjust axes etc
set(gca,'ydir','reverse','ylim',[0 0.5],'xlim',[0 max(tic14 + 10000)],'xtick',tic14,'xticklabel',tic14); grid on;
ylabel('Depth in core (m)');
xlabel('[^{14}C] (katoms g^{-1})');
set(gca,'ytick',ticz);
set(gca, 'FontSize', 10)

if core == 2
title('BH02 modelled concentrations vs. depth')
else
title('BH03 modelled concentrations vs. depth')
    
end


